#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils import *

class View:

    def __init__(self):
        self.cms = 'ecaws'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self ):
        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        dic.close()

        if scfg.get("PAGEMAKE"):
            if scfg.get("PAGEMAKE") == 'HTML':
                pages = GetHtmlMenuPages() 

        return render.ecaws(   web = web,
                                cms = self.cms,                        
                                scfg = scfg, 
                                pages = pages,
                                mode = 'view',
                                id = None,
                                html_file = None,
        )

class Edit:

    def __init__(self):
        self.cms = 'ecaws'
        web.header("Content-Type", "text/html; charset=UTF-8")
        web.header("Cache-Control", "no-cache, must-revalidate")
        web.header("Pragma", "no-cache")

    def GET( self, id="index" ):

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')
        dic.close()

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            return web.notfound()

        if fields is None:
            fields = {}

        html_fields = {}
        n = 0

        #ITEM
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'item'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            view_type = ama.get('data-paneo-amazon')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if f :
                    ama_asin = f.get('asin') 
                else:
                    ama_asin = {} 
                
                html_fields[k] = {  
                                    'idx':n ,
                                    'tag':ama.name,
                                    'title':title,
                                    'view-type':view_type,
                                    'paneo-name':paneo_name,
                                    'asin':ama_asin,
                } 
                n = n + 1

        #SEARCH
        n = 100
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'search'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            view_type = ama.get('data-paneo-amazon')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                if f :
                    ama_searchindex = f.get('searchindex') 
                    ama_kw = f.get('kw') 
                    ama_itempage = f.get('itempage') 
                    ama_sort = f.get('sort') 
                else:
                    ama_searchindex = "All" 
                    ama_kw = "" 
                    ama_itempage = "1" 
                    ama_sort = "" 
                
                html_fields[k] = {  
                                    'idx':n ,
                                    'tag':ama.name,
                                    'title':title,
                                    'view-type':view_type,
                                    'paneo-name':paneo_name,
                                    'searchindex':ama_searchindex,
                                    'kw':ama_kw,
                                    'itempage':ama_itempage,
                                    'sort':ama_sort,
                } 
                n = n + 1

        return render.ecaws(        web = web,
                                    cms = self.cms,                        
                                    mode = 'edit',
                                    id = id,
                                    scfg = scfg, 
                                    pages = pages,
                                    bs = bs,
                                    html_fields = html_fields,
                                    dt = dt,
        )


    def POST( self, id="index" ):

        i = web.input()

        dic = sqlite3dbm.sshelve.open(PANEO_DB)
        
        scfg = dic.get('siteconfig')
        pages = dic.get('pages')
        fields = dic.get('fields')

        try:
            file = codecs.open(PANEO_SITE_DATA_DIR+id+'.html',"r","utf8")
            bs = BeautifulSoup(file.read(),"html5lib",fromEncoding="utf8")
            file.close()
        except:
            pass

        if fields is None:
            fields = {}

        #ITEM
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'item'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            view_type = ama.get('data-paneo-amazon')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                
                ama_asin = {}
                for ii in range(1,11):
                    ama_asin["I:%s"%ii] = i.get("%s_asin_%s"%(k,ii))
                fields[k] = {
                        'tag':ama.name,
                        'title':title,
                        'view-type':view_type,
                        'paneo-name':paneo_name,
                        'asin':ama_asin
                }
                dic['fields'] = fields

        #SEARCH
        amas =  bs.find_all(attrs={'data-paneo-type':'amazon','data-paneo-amazon':'search'})
        for ama in amas:
            paneo_name = ama.get('data-paneo-name')
            title = ama.get('title')
            view_type = ama.get('data-paneo-amazon')
            if paneo_name is not None:
                k = ('ama_%s_%s'%(id,paneo_name))
                f = fields.get(k)
                
                fields[k] = {
                        'tag':ama.name,
                        'title':title,
                        'view-type':view_type,
                        'paneo-name':paneo_name,
                        'searchindex':i.get('SEARCHINDEX'),
                        'kw':i.get('KW'),
                        'itempage':i.get('ITEMPAGE'),
                        'sort':i.get('SORT'),
                }
                dic['fields'] = fields

        dic.close()
       
        return self.GET( id )

